package apps.conf;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
	

public class Login extends JDialog {
	
	private ConfUI ui;
	
	JTextField confIDField ;
	
	JPasswordField confPassField;
	
	JTextField confTopicField;
	
	JButton okButton;
	
	
	public Login(ConfUI ui) {
		super();
		this.ui = ui;
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
				System.exit(0);}
													});
		
		this.setTitle("Login:");
		
		JPanel dialogPane = new JPanel();
		
		JPanel infoPane = new JPanel();
		
		JPanel aPanel = new JPanel();
			
		confIDField = new JTextField("conf0");
		JLabel IDLabel = new JLabel("ConferenceID:");
		IDLabel.setLabelFor(confIDField);
		
		aPanel.add(IDLabel);
		aPanel.add(confIDField);
		aPanel.setLayout(new GridLayout());
		aPanel.setAlignmentX(Panel.LEFT_ALIGNMENT);
		
		JPanel bPanel = new JPanel();
		
		confPassField = new JPasswordField("conf0");
		JLabel passLabel = new JLabel("Password:");
		passLabel.setLabelFor(confPassField);
		
		bPanel.add(passLabel);
		bPanel.add(confPassField);
		bPanel.setLayout(new GridLayout());
		bPanel.setAlignmentX(Panel.LEFT_ALIGNMENT);
		
		
		JPanel cPanel = new JPanel();
		
		confTopicField = new JTextField("Testing Conference",30);
		JLabel topicLabel = new JLabel("Topic:");
		topicLabel.setLabelFor(confTopicField);
		
		cPanel.add(topicLabel);
		cPanel.add(confTopicField);
		
		
		
		infoPane.add(aPanel);
		infoPane.add(bPanel);
		infoPane.add(Box.createRigidArea(new Dimension(0,20)));
		infoPane.add(cPanel);
		
		infoPane.setLayout(new BoxLayout(infoPane,BoxLayout.Y_AXIS));
		infoPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		
		JPanel buttonsPane = new JPanel();
		
		okButton = new JButton("OK");
		okButton.addActionListener(ui);
										
		buttonsPane.add(Box.createHorizontalGlue());
		buttonsPane.add(okButton);
		
		buttonsPane.setLayout(new BoxLayout(buttonsPane,BoxLayout.X_AXIS));
		buttonsPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		
		dialogPane.add(infoPane);
		dialogPane.add(buttonsPane);
		dialogPane.setLayout(new BoxLayout(dialogPane,BoxLayout.Y_AXIS));
		
		this.getContentPane().add(dialogPane);
		this.setLocation(550,250);
		this.pack();
		
	}
	
	
	public void present() {
		
		this.setVisible(true);
	}
	
	
	
	/*
	public void actionPerformed(ActionEvent ae) {
		if (ae.getActionCommand().equals("OK")) {
			ui.login(this.confIDField.getText(),this.confPassField.getText(),this.confTopicField.getText());
			this.setVisible(false);
		}
			
	}
	*/
	
	public Object getLoginButton() {
		return this.okButton;
	}
	
	public void sendLogin() {
		ui.login(this.confIDField.getText(),this.confPassField.getText(),this.confTopicField.getText());
	}
	
	public void fail() {
		this.setVisible(false);
		try {
			Thread.currentThread().sleep(500);
		}catch (InterruptedException e) {}
		this.setVisible(true);
	}
	
	
}
